//Effect of Adding a Pole (1+Tp s)to OL tr fn G=wn^2/(s(s+2zeta wn))on CL tr fn T=wn^2/(Tp s^3+(1+2zeta wn Tp)s^2+2zeta wn s+wn^2)of a II order system 
s=%s;
t=0:0.1:30;
zeta=1;  wn=1;
Tp=[0 1 2 5];     //Poles added are s=-1/Tp i.e poles at -1/0, -1/1, -1/2, -1/5
line_style=[1 2 3 4];        // for dashed, dotted,.... lines
for n=1:4    
   T=syslin('c',wn^2,(Tp(n)*s^3+(1+2*zeta *wn*Tp(n))*s^2+2*zeta *wn *s+wn^2));
   Ts=csim('step',t,T);
   xset("line style",line_style(n));
   plot2d(t,Ts,style=1);  // style=1 for black line
end;
xgrid(3);                //green grid
xtitle(['Effect of Adding a Pole (1+Tp s) to OL tr fn G = wn^2 / ( s (s + 2zeta wn))'],'Time(sec)', 'c(t)' );
legends(['s = -1/0';'s = -1/1';'s = -1/2';'s = -1/5'],[[1;1],[1;2],[1;3],[1;4]],opt=4);
